.TH rtrm 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rtrm.c - delete RT-11 files 
.SH SYNOPSIS
rtrm [-b <b/s>] [-s <s/t>] [-t <t/d>] [-r] file1 ... filen

.SH DESCRIPTION
Rtrm removes RT-11 files.  If given a list of files, it will attempt to 
delete each one, even if prior deletes fail.  Each file must have
a proper device prefix - this can be handled by using the csh
construct:  rtrm device/{bar1,bar2,bar3}.

The command line switches -b, -s, and -t set bytes per sector, sectors
per track, and tracks per disk, respectively.  These default to 128,
26, and 77, which are the correct numbers for a single density 8" floppy.
The -r flag turns off the usual RT-11 interleave.

.SH NOTE
You may have to be the superuser to access the disk special
files as required by this program.

.SH EXAMPLES
.CS
        rtrm /dev/flop.sd.8/{file1,file2,file3}
.CE
removes the files file1, file2, file3 from the single-density, 8" floppy
disk in /dev/flop.sd.8.
.CS
        rtrm -b 512 -s 15 /dev/flop.dd.8/file1
.CE
removes the file file1 from the double density 8" RT-11 disk on /dev/flop.dd.8.

.SH SEE ALSO
rtinit(4), rtls(4), rt11Lib(1)
