.TH rtls 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rtls.c - list directory of RT-11 volume 
.SH SYNOPSIS
rtls  [-b <b/s>] [-s <s/t>] [-t <t/d>] [-r] <special>

.SH DESCRIPTION
This program lists the directory of an RT-11 disk.
<special> is the special file for the disk drive containing the
RT-11 disk.  The files are listed in the format of standard ls with
the long (-l) option.  Much of the information is dummy stuff to
conform to the ls format.  The meaningful info is the file size,
date, and name.  Empty slots on the disk are displayed with name
"(EMPTY)".

The options -b, -s, and -t set bytes per sector, sectors per track,
and tracks per disk, respectively.
These default to 128, 26, and 77, which are the correct
numbers for a single density 8" floppy.  The -r flag turns off the usual
RT-11 interleave.

.SH NOTE
In general you have to be the superuser to access the disk special
files as required by this program.

.SH EXAMPLES
.CS
        rtls /dev/flop.sd.8
.CE
lists the directory of the single density 8" RT-11 diskette on /dev/flop.sd.8.
.CS
        rtls -b 512 -s 15 /dev/flop.dd.8
.CE
lists the directory of the double density 8" RT-11 disk on /dev/flop.dd.8.
.CS
        rtls -b 512 -s 9 -t 35 /dev/flop.dd.5
.CE
lists the directory of the double density 5 1/4" RT-11 disk on /dev/flop.dd.5.

.SH DEFICIENCIES
The only listing format is the ls long (-l) format.  This should
be an option and other ls formats should be supported.  Also the
files are listed in the order they appear on the disk rather than
sorted alphabetically.

You can't read a double density disk produced by a DEC machine, since
it can't be described in the options available.

.SH SEE ALSO
"Cross Development", rtinit(4), rtcp(4), rt11Lib(1)
