.TH rtinit 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rtinit.c - initialize directory of RT-11 volume 
.SH SYNOPSIS
rtinit  [-b <b/s>] [-s <s/t>] [-t <t/d>] [-r] <special>

.SH DESCRIPTION
This program initializes the directory of an RT-11 format disk.
<special> is the special file for the disk drive containing the
RT-11 disk. The options -b, -s, and -t are used to set bytes per
sector, sectors per track, and tracks per disk.  They default to
128, 26, and 77 respectively, which are the right numbers for
a single density 8" floppy.  The -r flag turns off the usual RT-11
interleave.

.SH NOTE
You must have read/write access to the disk device referred to.

.SH EXAMPLES
.CS
        rtinit /dev/flop.sd.8
.CE
initializes the single density 8" diskette on /dev/flop.sd.8 to be an
empty RT-11 disk.
.CS
        rtinit -b 512 -s 15 /dev/flop.dd.8
.CE
initializes the double density 8" diskette on /dev/flop.dd.8 to be an
empty RT-11 disk.
.CS
        rtinit -b 512 -s 9 -t 35 /dev/flop.dd.5
.CE
initializes the double density 5 1/4" diskette on /dev/flop.dd.8 to be an
empty RT-11 disk.

.SH DEFICIENCIES
You can't initialize a real double density disk that will work on a DEC
machine.  Single density 8" will work fine.

.SH SEE ALSO
"Cross Development", rtls(4), rtcp(4), rt11Lib(1)
