.TH relseg 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
relseg.c - relocate program segments to fixed addresses 
.SH SYNOPSIS
relseg [-t text-address] [-d data-address] [-b bss-address] [-o outfile] file

.SH DESCRIPTION
This program relocates the specified object module file, putting the
text, data, and bss segments at fixed addresses.
The segments are put at the addresses of the specified flags.
If no text address is specified, the text segment is put at 0.
If no data address is specified, the data segment is put immediately following
the text segment.
If no bss address is specified, the bss segment is put immediately following
the data segment.
The entry address is modified according to the text address.

The input object module should be fully linked but still relocatable.
The new object module is left in "rel.out"
and is NOT eligible for further linking or relocating.
The output file name may be specified with the "-o" option.

.SH WARNING
If relseg detects that a module was compiled with the ``-g'' source debugging
option, it will print a warning.  Modules compiled this way result in very
unoptimal code that may not be appropriate to put in ROM, which is often
the purpose of using this tool.

.SH EXAMPLE
Suppose we want to create an object module in which the text and data 
segments are to be placed in a ROM whose address is 0xeee000, but whose
bss segment is to be placed in RAM at address 0x1000.
The commands to do this are:

        ld -o gronk -X -rd gronk.o ...
        relseg -t ee0000 -b 1000 gronk

The file "rel.out" is created containing the relocated object module.

.SH SEE ALSO
UNIX BSD 4.3 a.out.h
