.TH aspp 4 "" "VxWorks Reference Manual"
.ad b
.SH NAME
aspp - pre-processor for as (mit assembler)
.SH SYNOPSIS
aspp [files...]

.SH DESCRIPTION
This script reads the specified files (or standard input if no files 
specified) and writes to standard output, transforming Motorola style
register lists (on "move multiple registers" instructions)
into the numeric constant required by some MIT-format 68K assemblers.

Arguments are converted if they are of the proper form, if they are
arguments of a movem (or movm, moveml, movemx, fmovem, etc.), and if they
are not in a comment.

.SH EXAMPLE
The following transformation would be made from input to output.

   input file:
      moveml  d1-d3/a2-a3,a7@-        /* save regs 
      moveml  a7@+,d1-d3/a2-a3        /* restore regs 

   output file:
      moveml  #0x7030,a7@-            /* save regs 
      moveml  a7@+,#0x0c0e            /* restore regs 

.SH NOTE
The bit pattern in a moveml instruction for a certain set of registers
is inverted left-to-right for auto-decrement instructions as opposed
auto-increment instructions.
A moveml instruction with neither auto-increment nor auto-decrement uses
the same bit pattern as auto-increment.
