.TH ty534Drv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ty534Drv.c - tty driver for the Intel 534 serial controller board 
.SH SYNOPSIS
.nf
ty534Drv - install Intel 534 driver
ty534DevCreate - create a device for a channel

STATUS ty534Drv ()
STATUS ty534DevCreate (name, channel, rdBufSize, wrtBufSize, baudRate)
.fi
.SH DESCRIPTION
This is the driver for the Intel 534 serial controller board.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly: ty534Drv () to
initialize the driver, and ty534DevCreate to create devices.

.SH TY534DRV
Before using the driver, it must be initialized by calling the routine:
.CS
    ty534Drv ()
.CE
This routine should be called exactly once, before any reads, writes, or
ty534DevCreate's.  Normally, it is called from usrRoot (2) in usrConfig.c.

.SH CREATING TERMINAL DEVICES
Before a terminal can be used, it must be created.
This is done with the ty534DevCreate call.
Each port to be used should have exactly one device associated with it,
by calling this routine.

.CS
 STATUS ty534DevCreate (name, channel, rdBufSize, wBufSize, baudRate)
     char *name;     /* Name to use for this device *
     int channel;    /* Physical channel for this device (0 - 3) *
     int rdBufSize;  /* Read buffer size, in bytes *
     int wBufSize;   /* Write buffer size, in bytes *
     int baudRate;   /* Baud rate to create device with *
.CE

For instance, to create the device "/ty534/0", with buffer sizes of 512 bytes,
at 9600 baud, the proper call would be:
.CS
   ty534DevCreate ("/ty534/0", 0, 512, 512, 9600);
.CE
.SH IOCTL
This driver responds to all the same ioctl codes as a normal ty driver.
All baud rates between 110 and 19200 are available.
