.TH smsDrv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
smsDrv.c - disk driver for the SMS 8007, or Intel iSBC 214 board 
.SH SYNOPSIS
.nf
smsDrv - install SMS driver
smsDevCreate - create an SMS device
smsDbg - turn debugging output on/off
smsRomboot - hook for setting ROMBOOT mode for driver

STATUS smsDrv ()
STATUS smsDevCreate (name, drive, rtFmt, trackOffset, nTracks, devType)
VOID smsDbg (new_debug)
VOID smsRomboot ()
.fi
.SH DESCRIPTION
This is the I/O driver for the Intel iSBC 214,
or the Scientific Micro Systems 8007,
Multibus disk controller board.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly, smsDrv () to
initialize the driver, and smsDevCreate () to create devices.

.SH SMSDRV
Before using the driver, it must be initialized by calling the routine:
.CS
    smsDrv ()
.CE
This routine should be called exactly once, before any reads, writes, or
smsDevCreates.  Normally, it is called from usrRoot.

.SH CREATING DISK DEVICES
Before a disk device can be used, it must be created.
This is done with the smsDevCreate call.
Each drive to be used may have one or more devices associated with it,
by calling this routine.
The way the device is created with this call determines whether the 
device will be single or double density, whether it covers the whole
disk or just part of it, whether it is RT-11 format compatible, etc.

.CS
 STATUS smsDevCreate (name, drive, rtFmt, trkOffset, nTracks, devType)
     char *name;     /* name of this device *
     int drive;      /* drive number 0-3 floppy/tape, 4-7 hard disk *
     BOOL rtFmt;     /* TRUE if this device is RT-11 formatted *
     int trkOffset;  /* number of tracks offset from beginning
                      * of physical device *
     int nTracks;    /* length of this device, in tracks;
                      * if 0, the rest of the disk *
     int devType;    /* SS_1D_8, SS_2D_8, DS_1D_8, DS_2D_8, or HD_1 *
.CE

For instance, to create the device "/fd0d/", RT-11 compatible, covering
the whole disk, single density, on drive 0, the proper call would be:
.CS
    smsDevCreate ("/fd0d/", 0, TRUE, 1, 0, 1);
.CE
.SH IOCTL
This driver responds to all the same ioctl codes as a normal block
device driver.  To format a disk use FIODISKFORMAT.

.SH RT-11 COMPATIBILITY
In order to maintain true RT-11 compatibility, to the extent that a floppy
may be written under VxWorks and read under RT-11, or vice-versa, the device
must be created single density, with RT-11 formatting TRUE, and with a track
offset of 1.

.SH MULTIPLE DEVICES ON A DRIVE
It is possible, and reasonable, to have more than one logical device for
a drive.  For instance, if the drive will sometimes be accessed in
RT-11 compatible single density format, and sometimes in double
density non-RT-11, and sometimes as a special device covering only
a few tracks, the following three devices might be created:
.CS
    smsDevCreate ("/rt0/", 0, TRUE, 1, 0, 1);
    smsDevCreate ("/fd0/", 0, FALSE, 0, 0, 2);
    smsDevCreate ("/xd0/", 0, FALSE, 10, 10, 2);
.CE
Now, by using devices named "/rt0/", "/fd0/", or "/xd0/", the drive
may be accessed in any of the ways described above.
