.TH rfDrv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rfDrv.c - rimfire 3200 driver 
.SH SYNOPSIS
.nf
rfDrv - install rimfire driver
rfCtlrInit -
rfMalloc -
rfFree -
rfDevCreate - 
rfDevMount -
rfDevShow -
rfLabelCreate -
rfLabelPrint - 
rfLabelRead -
rfLabelWrite -
rfXPBClear -
rfIoctlInfoPtrGet -
rfConfig -
rfConfigGet -
rfFormat -
rfSync -
rfVerify -
rfSMDChrsPrint -
rfConfigParamsPrint -

STATUS rfDrv (cpuDualPort)
STATUS rfCtlrInit (addrs, intVec, intLvl, ctlr, driveCnt, devType )
char *rfMalloc (nBytes)
STATUS rfFree (pBlock)
STATUS rfDevCreate (name, ctlr, drive, rtFmt, trkOffset, nTracks, devType)
STATUS rfDevMount (name, ctlr)
STATUS rfDevShow (ctlr, drive)
STATUS rfLabelCreate (ctlr, drive, devType )
VOID rfLabelPrint (pLabel)
STATUS rfLabelRead (ctlr, drive, pLabel)
STATUS rfLabelWrite(ctlr, drive, pLabel)
STATUS rfXPBClear (pXPB)
IOCTL_INFO *rfIoctlInfoPtrGet (pRfDev)
STATUS rfConfig (ctlr, drive, pGeomReq)          ...
STATUS rfConfigGet (ctlr, drive, pConfGetReq)            ...
STATUS rfFormat (ctlr, drive, pFmtReq)           ...
STATUS rfSync (ctlr, drive)
STATUS rfVerify (pRfDev, pVerReq)                ...
VOID rfSMDChrsPrint (ctlr, drive, pSMDChrs)
VOID rfConfigParamsPrint (ctlr, drive, pRetConf)
.fi
.SH DESCRIPTION
This is the device driver for the Ciprico Rimfire 3200 SMD hard disk 
controller board.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system. However, several routines are callable from the application level.
These are:
rfDrv, rfCtlrInit, rfDevCreate, rfDevMount, rfDevShow, rfLabelCreate,
rfLabelPrint, rfLabelRead, rfLabelWrite, rfConfig, rfConfigGet, 
rfFormat, rfVerify.

.SH INITIALIZATION
rfDrv

Before using the driver, it must be initialized by calling the function
rfDrv.

.CS
rfDrv (cpuDualPort)
    BOOL cpuDualPort;                   /* does cpu dual port mem ? *
.CE

This function should be called exactly once, before any reads, writes, or
rfDevCreates.  Normally, it is called from usrRoot. The function rfCtlrInit
is used to initialize the controller and drive hardware,  and connect the 
interrupt handler. The argument 'cpuDualPort, tells the driver whether to
use the system memory, on the cpu board, or allocate it's own memory pool
in extened memory. The dimensions of this are given by RF_MEM_BASE and
.SH RF_MEM_SIZE.


.CS
STATUS rfCtlrInit (addrs, intVec, intLvl, driveCnt, ctlr)
    UINT addrs;    /* address of rf controller board *
    UINT intVec;   /* interrupt vector for controller *
    UINT intLvl;   /* interrupt  level of controller *
    UINT driveCnt; /* number of physical drives on controller *
    UINT ctlr;     /* controller number. (zero based) *
.CE    
.SH CONFIGURING
Before a drive can be accessed by the rimfire 3200, the controller must be
configured with the geometery of the drive . If the drive has been formatted
and the label created, the call to rfCtlrInit would have obtained the 
disk geometery from the disk label and configured the controller accordingly.
If the drive has not been formatted, the function rfConfig must be used to
configure the controller so that formatting can be done.

.CS
STATUS rfConfig (ctlr, drive, pGeomReq) 
    int ctlr;            /* controller number *
    int drive;           /* drive number *
    DISK_GEOM *pGeomReq; /* user's requested geometry *
.CE

The DISK_GEOM structure is used to pass in the geometery information to 
the controller (see rfLabel.h). 

.SH FORMATING
Before a disk can be used it must be formatted. To format a disk that has
never been formated by a rimfire 3200, and this driver, the following 
funtctions must used.

    rfDrv (...);        - see above.
    rfCtlrInit (...);   - see above.
    rfConfig (...)      - see above.

STATUS rfFormat (ctlr, drive, pFmtReq)
    int ctlr;                   /* controller number *
    int drive;                  /* drive number *
    FMT_VER_REQ *pFmtReq;       /* format request block *

The FMT_VER_REQ structure is used to tell rfFormat where to start and
stop formatting. To format the entire disk, both these fields should 
be set to zero. Formatting errors are placed in the error field before
rfFormat returns (see Ciprico manual for more information).

VERIFYING XXXsp

Once a disk has been formatted, disk defects need to be handled. Bad sectors
can be slipped or mapped, and bad tracks can be mapped. (see section 4
Functional Description - Defect Mapping in the Ciprico manual for details.)
To verify the format of a disk, the function rfVerify is used.
Because rfVerify is dependent on a device descriptor, a disk device must 
be created and the device opened. rfVerify is then called via the I/O system
using ioctl. The following example shows how to create and open a disk device.

Example:

    int fd;                                     /* file descriptor *
    rfDevCreate ("/d0/", 0, 1, 0, 1, 0, 0);     /* create device *
    fd = open ("/d0/", 1);                      /* open disk *
    ioctl (fd, FIOVERIFY, pFmtVerReq);          /* verify disk *

The argument pFmtVerReq is a pointer to a structure of type FMT_VER_REQ.
where the starting and ending blocks are specified. To verify the entire
disk both the starting and ending block fields should be zero. Verify will
run until a bad block is encountered. The error field of pFmtVerReq will
be set to show the error code and the badBlock field will contain the 
number of the block that is defective. This block number can then be used to
slip the sector or map the sector or track to an alternate. If the disk 
geometry is setup such that there are spare sectors per track, the sector 
can be slipped. If there are no spares or the slip command fails, then the
sector or track needs to be mapped to an alternate location on the disk.


.SH DISK DEVICES
Before a disk device can be used, it must be created. This is done with 
the rfDevCreate call.
Each drive to be used may have one or more devices associated with it.
The way the device is created with this call determines whether 
it covers the whole disk or just part of it  , whether it is RT-11
format compatible, etc.

.CS
STATUS rfDevCreate (name, ctlr, drive, rtFmt, trkOffset, nTracks, devType)
    char *name;     /* name of this device *
    int  ctlr;      /* controller number . 0 based*
    int  drive;     /* physical drive number. 1 based *
    BOOL rtFmt;     /* TRUE if this device is RT-11 formatted *
    int  trkOffset; /* tracks offset from base of phys drive *
    int  nTracks;   /* len of dev, in tracks: 0 remainder of disk*
    int  devType;   /* disk type *
.CE

For instance, to create the device "/d0/", RT-11 compatible, covering
the whole disk, on drive 1, the proper call would be:

.CS
    rfDevCreate ("/d0/", 0, 1, TRUE, 1, 0, 0);
.CE

The arguments passed to this funtion are stored on the disk label so 
when the system is rebooted, the devices do not need to be recreated.
Once a logical device has been created on the disk it must be inittialized
by a call to diskinit() with the logical device name as its argument.

Example:
        diskinit ("/fd0d/");

This call initializes the directory structure on the disk so that it can 
be used by the file system. Because the paramters for the logical devices 
are kept in the disk label the logical devices can be mounted upon system
reboot by calling rfDevMount with the name of the logical device as its
argument. To find out the names of logical devices on a disk call rfDevShow.
Example:

    rfDevShow (ctlr, drive);
    pNo  name  drv  fmt  ofst  len  type
     0   d0     1    0     1    0     0

    rfDevMount ("/d0/");

Now the device /d0/ can be used by the I/O system.


.SH MULTIPLE DEVICES ON A DRIVE
It is possible, and reasonable, to have more than one logical device for
a given drive. rfDevCreate can be called multiple times to create multiple 
devices.

.SH IOCTL
This driver responds to all the same ioctl codes as a normal block
device driver.  Note that currently the defines for ioctl calls for the
rimfire exist in two places, rfIoctl.h and /usr/vw/h/ioLib.h.
