.TH ramDrv 3 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ramDrv.c - ram disk driver 
.SH SYNOPSIS
.nf
ramDrv - install ram disk driver
ramDevCreate - create a ram disk device
ramMkfs - create a ram disk device with an RT-11 file system

STATUS ramDrv ()
STATUS ramDevCreate (name, where, bytesSec, secTrack, nSectors, ...
STATUS ramMkfs (name, nbytes, where, dontInit)
.fi
.SH DESCRIPTION
This driver emulates a disk driver, but actually keeps all data in memory.
The memory location, and the size of the disk, may be specified on the 
ramDevCreate () call.  This is useful for data that might need to be
kept around between boots of VxWorks, or for sharing data between CPU's.

The RT-11 file and directory structure is used.

.SH USER CALLABLE ROUTINES
Most of the routines in this driver are accessible only through the I/O
system.  Two routines, however, must be called directly, ramDrv () to
initialize the driver, and ramDevCreate () to create devices.  Also,
ramMkfs () provides a somewhat easier way to create devices.

.SH RAMDRV
Before using the driver, it must be initialized by calling the routine:
.CS
    ramDrv ()
.CE
This routine should be called exactly once, before any reads, writes, or
ramDevCreates.  It may be called from usrRoot(2) in usrConfig.c, or
at some later point.

.SH CREATING RAM-DISKS
Before a ram disk can be used, it must be created.  This is done
with the ramDevCreate call.  The format of this call is:

.CS
    STATUS ramDevCreate (name, where, bytesSec, secTrack,
                         nSectors, rtFmt, secOffset)
        char *name;     /* Device name *
        char *where;    /* Where it is in memory (0=malloc) *
        int bytesSec;   /* Number of bytes per sector *
        int secTrack;   /* Number of sectors per track *
        int nSectors;   /* Number of sectors on this device *
        BOOL rtFmt;     /* TRUE = RT-11 skew and intereleave *
        int secOffset;  /* Number of sectors to skip at *
                         * beginning of physical device *
.CE

The memory for the ram disk may be allocated separately;
the `where' parameter points to it.
The formatting parameters (bytesSec, secTrack, nSectors, rtFmt) are critical
only if the ramdisk memory already
contains an image of a disk, created elsewhere.  In that case, the
formatting parameters must be identical to those used when the image
was created.  Otherwise, they may be any convenient number.
In this case, 512 is a good sector size,
secTrack could be == nSectors, rtFmt could be FALSE, and secOffset == 0.

For instance, to create the device "/ram/0/", a 200KB ram disk with
these parameters, the proper call would be:
.CS
    ramDevCreate ("/ram/0/", malloc (200000), 512, 2000/512,
                  2000/512, FALSE, 0)
.CE
Note that when the disk is created in this fashion, it is not yet formatted.
This must be done with the FIODISKINIT ioctl call.

.SH RAMMKFS
RamMkfs provides a convenient way to create and initialize
ram disks with standard parameters. The format of the call is:

.CS
    STATUS ramMkfs (name, nbytes, where, dontInit)
        char *name;     /* Device name *
        int nbytes;     /* Number of bytes total for ram disk *
        char *where;    /* Where it is in memory (0=malloc) *
        BOOL dontInit;  /* FALSE = initialize RT-11 directory, *
                         * TRUE  = don't *
.CE

The device is created with the specified name and size.  If no
memory address is specified, then memory for the ram disk will
be allocated from the pool.
Unless `dontInit' is specified TRUE, an RT-11 directory will be
initialized on the newly created device.

The ram devices created by this routine have 512 byte "sectors",
1 "track", do not have "RT-11 compatible skew and interleave",
and have 0 sector offset (see ramDevCreate for details).

For example, the shell command:
.CS
        -> ramMkfs "/ram/",200000
.CE
creates a ram device named "/ram/" with 200000 bytes of memory
allocated from the pool, and initializes an RT-11 directory on it.

The shell command:
.CS
        -> ramMkfs "/ram/",200000,0xc0000,1
.CE
creates a ram device whose starting address is 0xc0000 and does
NOT initialize an RT-11 directory on it.  This might be useful
if a ram disk was created at that same address in a previous
boot of VxWorks.  The contents of the ram disk would be unchanged.

.SH IOCTL
The ram driver responds to all the same ioctl codes as a normal disk driver.
These are described in the "I/O System" chapter, and in rt11Ioctl (2).

.SH SEE ALSO
"I/O System", rt11Ioctl (2)

