.TH vxMemProbe 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
vxMemProbe - probe address for bus error
.SH SYNOPSIS
.CS
.nf
STATUS vxMemProbe (adrs, mode, length, pVal)
    char *adrs;         /* address to be probed          */
    int mode;           /* READ or WRITE                 */
    int length;         /* 1, 2, or 4                    */
    char *pVal;         /* where to return value,        */
                        /* or ptr to value to be written */
.fi
.CE
.SH DESCRIPTION
This routine probes the specified address to see if it is readable or
writable, as specified by the mode argument.  The address will be read/written
as 1, 2, or 4 bytes as specified by the length argument (values
other than 1, 2, or 4 yield unpredictable results).
If the probe is a READ, then the value read will be returned in the
location pointed to by the `pVal' argument.
If the probe is a WRITE, then the value written will be taken from the
location pointed to by the `pVal' argument.
In either case, `pVal' should point to a value of the appropriate length, 
1, 2, or 4 bytes, as specified by the length argument.

Note that only bus errors are trapped during the probe, and that the
access must be otherwise valid (i.e. not generate an address error!).

.SH EXAMPLE
.CS
testMem (adrs)
   char *adrs;
   {
   char testW = 1;
   char testR;

   if (vxMemProbe (adrs, WRITE, 1, &testW) == OK)
       printf ("value %d written to adrs %x\n", testW, adrs);

   if (vxMemProbe (adrs, READ, 1, &testR) == OK)
       printf ("value %d read from adrs %x\n", testR, adrs);
   }
.CE

.SH RETURNS
 OK if the probe is successful, or
 ERROR if the probe caused a bus error
.SH SEE ALSO
vxLib(1)
