.TH tyIoctl 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
tyIoctl - special device control
.SH SYNOPSIS
.CS
.nf
STATUS tyIoctl (pTyDev, request, arg)
    TY_DEV_ID pTyDev;     /* pointer to device to control */
    int request;          /* request code                 */
    int arg;              /* some argument                */
.fi
.CE
.SH DESCRIPTION
This routine handles device control requests for "tty" devices.
It handles the following requests:

  ioctl (fd, FIONREAD, &nBytes)
      return in nBytes the number of characters 
      available in the input buffer

  ioctl (fd, FIONWRITE, &nBytes)
      return in nBytes the number of characters 
      available in the output buffer

  ioctl (fd, FIOFLUSH)
      discard all characters currently in input and 
      output buffers

  ioctl (fd, FIOSETOPTIONS, options)
  ioctl (fd, FIOOPTIONS, options)
      set device options. If the line-protocol (OPT_LINE) 
      is changed, the input buffer is flushed.
      The various options are described in tyLib.h

  ioctl (fd, FIOGETOPTIONS)
      returns the current device options

  ioctl (fd, FIOCANCEL)
      cancel read or write

  ioctl (fd, FIOISATTY)
      returns TRUE

Any other request will return ERROR, and set status to
S_ioLib_UNKNOWN_REQUEST.

.SH BUGS
In line-protocol mode (OPT_LINE option set) FIONREAD actually returns
the number of characters available PLUS the number of lines in the buffer.
Thus if five lines consisting of just newlines were in the input buffer,
FIONREAD would return the value ten (five characters + five lines).

.SH SEE ALSO
tyLib(1)
