.TH trcStack 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
trcStack - print trace of function calls from stack
.SH SYNOPSIS
.CS
.nf
VOID trcStack (fp, sp, pc, printRtn)
    int *fp;          /* stack frame pointer (A6) */
    int *sp;          /* stack pointer */
    INSTR *pc;        /* program counter */
    FUNCPTR printRtn; /* routine to print single function call */
.fi
.CE
.SH DESCRIPTION
This routine provides the low-level stack trace function.
(A higher-level symbolic stack trace built on top of this is provided
by the routine tt (2) in dbgLib (1).)

A list of the nested routine calls that are on the stack is printed.
Each routine call, with its parameters, will be shown.

The stack being traced should be quiescent.  One should especially
avoid trying to trace one's own stack.

.SH PRINT ROUTINE
In order to allow symbolic or other alternative printout formats,
the call to this routine includes the "printRtn" parameter, which
is a routine to be called at each nesting level to print out the
routine name and its arguments.  This routine should be declared as
follows:
.ne 7
.CS

  VOID printRtn (callAdrs, rtnAdrs, nargs, args)
    INSTR *callAdrs;  /* address from which routine was called *
    int rtnAdrs;      /* address of routine called *
    int nargs;        /* number of arguments in call *
    int *args;        /* pointer to arguments *

.CE

If a NULL printRtn is specified, then a default routine will be used
which just prints out the call address, function address, and
arguments as hexadecimal values.

.SH CAVEAT
In order to do the trace, some assumptions are made.
In general, the trace will work for all C language routines,
and for assembly language routines that start with a LINK instruction.
Most VxWorks assembly language routines include LINK instructions for 
exactly this reason.
However, routines written in other languages, strange entries into
routines, or tasks with corrupted stacks, can make the trace very confused.
Also, all parameters are assumed to be 32-bit quantities, so structures
passed as parameters will be displayed as some number of long integers.

.ne 14
.SH EXAMPLE
The following sequence can be used
to trace a VxWorks task given a pointer to the task's TCB:
.CS

  int dregs[8];       /* task's data registers
  int aregs[7];       /* task's address registers
  char *sp;           /* task's stack pointer
  unsigned short sr;  /* task's status register
  INSTR *pc;          /* task's program counter

  taskRegsGet (taskId, dregs, aregs, &sp, &sr, &pc);
  trcStack ((int*)aregs[6], (int*)sp, pc, (FUNCPTR)NULL);

.CE

.SH SEE ALSO
trcLib(1),
tt(2)
