.TH timexHelp 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
timexHelp - print help screen for timex
.SH SYNOPSIS
.CS
.nf
VOID timexHelp ()
.fi
.CE
.SH DESCRIPTION
This routine prints a help screen which shows all the available
execution timer functions.

.CS
 -> timexHelp
              
 timexHelp                      Print this list
 timex       [func,[args...]]   Time single execution
 timexN      [func,[args...]]   Time repeated execution
 timexClear                     Clear all functions
 timexFunc   i,func,[args...]   Add timed function 'i'
 timexPre    i,func,[args...]   Add pre function 'i' (before timing)
 timexPost   i,func,[args...]   Add post function 'i' (after timing)
 timexShow                      Show all functions to be called

 Notes:
   1) timexN will repeat calls enough times to get
      timing accuracy to approximately 2%.
   2) one function can be specified on timex and timexN;
      alternatively functions can be pre-set with timexFunc.
   3) up to 4 functions can be pre-set with timexFunc,
      timexPre and timexPost, i.e. 'i' in range 0..3.
   4) timexPre and timexPost allow locking/unlocking, or
      raising/lowering priority before/after timing.
 value = 1 = 0x1
 -> 
.CE
.SH SEE ALSO
timexLib(1)
