.TH taskSpawn 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskSpawn - spawn a task
.SH SYNOPSIS
.CS
.nf
int taskSpawn (name, priority, options, stacksize, entryAddress, arg1,
         arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10)
    char *name;           /* task name of new task     */
    int priority;         /* priority of new task      */
    int options;          /* options word for new task */
    int stacksize;        /* size (in bytes) of stack  */
    FUNCPTR entryAddress; /* entry point of task       */
    int arg1;             /* arguments passed to task  */
    int arg2;
    int arg3;
    int arg4;
    int arg5;
    int arg6;
    int arg7;
    int arg8;
    int arg9;
    int arg10;
.fi
.CE
.SH DESCRIPTION
This routine creates a new task with the given priority, id, and options.
If the task name is specified as NULL, the name will be an ASCII
number which increments as tasks are spawned

Bits in the options argument may be set to run with the following modes.
.CS
      VX_SUPERVISOR_MODE      -  execute in supervisor mode
      VX_UNBREAKABLE          -  don't allow break point debugging
      VX_DEALLOC_STACK        -  deallocate the stack on deletion
      VX_FP_TASK              -  execute with coprocessor support
      VX_STDIO                -  execute with standard I/O support
.CE
See definitions in taskLib.h.

The entry address is the address of the main routine of the task.
This routine will be called with the specified arguments (up to 10).  
A stack of the specified size will be allocated from the memory pool.  
Stack size should be even.  Every byte of this stack is initialized to 0xEE, 
as a debugging aid.  See checkStack (2) for stack size checking aids.

See taskCreate (1) for creating tasks with preallocated stacks.

.SH BUGS
All tasks are spawned in supervisor mode, regardless of 
the specified option.  In effect, VX_SUPERVISOR_MODE is or'd into the
user specified options.  This is done because other VxWorks facilities
do not make a distinction of privileged instructions.

.SH RETURNS
task id, or ERROR if out of memory or unable to create task

.SH SEE ALSO
taskLib(1),
taskCreate (2), taskActivate (2)

