.TH taskRegsGet 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskRegsGet - get a task's registers from TCB
.SH SYNOPSIS
.CS
.nf
STATUS taskRegsGet (tid, dregs, aregs, sp, sr, pc)
    int tid;        /* task id                            */
    int dregs[];    /* buffer for data registers (0-7)    */
    int aregs[];    /* buffer for address registers (0-6) */
    char **sp;      /* buffer for stack pointer           */
    USHORT *sr;     /* buffer for status register         */
    INSTR **pc;     /* buffer for program counter         */
.fi
.CE
.SH DESCRIPTION
This routine gathers information about a task which is kept in the TCB.
It returns, in the locations whose pointers are
passed as parameters, the task's address and data registers, and its
SP, SR and PC.  The address and data registers are returned in
separate arrays, each containing 8 registers.

.SH NOTE
This routine only works well if the specified task's TCB is not that
of the calling task.  Results are unpredictable if a task tries to
discover its own registers.

.SH SEE ALSO
taskLib(1),
taskRegsSet(2)
