.TH taskCreate 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskCreate - create a task with stack at specified address
.SH SYNOPSIS
.CS
.nf
int taskCreate (name, priority, options, botOfStack, stksize, pTcb,
           entryAdrs, arg1)
    char *name;            /* name of new task           */ 
    int priority;          /* priority of new task       */
    int options;           /* task option word           */
    char *botOfStack;      /* bottom of new task's stack */
    int stksize;           /* size (bytes) of stack      */
    WIND_TCB *pTcb;        /* address of new task's TCB  */
    FUNCPTR entryAdrs;     /* initial pc of new task     */
    int arg1;              /* 1st of up to 10 arguments  */
.fi
.CE
.SH DESCRIPTION
This routine works like taskSpawn (2),
but instead of allocating the stack and TCB extension automatically,
it uses the stack and TCB extension passed as arguments.
The stack will grow towards lower memory locations
starting from the specified bottom of stack.

Bits in the options argument may be set to run with the following modes.
.CS
      VX_SUPERVISOR_MODE      -  execute in supervisor mode
      VX_UNBREAKABLE          -  don't allow debugging
      VX_DEALLOC_STACK        -  deallocate the stack on deletion
      VX_FP_TASK              -  execute with coprocessor support
      VX_STDIO                -  execute with standard I/O support
.CE
See definitions in taskLib.h.

The name of a task should be malloc'd along with the stack and TCB extension.
taskSpawn (2) will automatically name an unnamed task but taskCreate will not.
Normally, tasks should be started by taskSpawn (2), not by taskCreate.

.SH BUGS
All tasks are spawned in supervisor mode, regardless of 
the specified option.  In effect, VX_SUPERVISOR_MODE is or'd into the
user specified options.  This is done because other VxWorks facilities
do not yet make the distinction of privileged instructions.

.SH RETURNS
task id or ERROR if unable to create task

.SH SEE ALSO
taskLib(1),
taskActivate (2), taskSpawn (2)

