.TH symFindByValue 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
symFindByValue - find a symbol in a symbol table, given the value
.SH SYNOPSIS
.CS
.nf
STATUS symFindByValue (pTbl, val, name, pVal, pType)
    SYMTAB *pTbl; /* pointer to symbol table                    */
    int val;      /* value of symbol to find                    */
    char *name;   /* pointer where to return symbol name string */
    int *pVal;    /* pointer where to return symbol address     */
    UTINY *pType; /* pointer where to return symbol type        */
.fi
.CE
.SH DESCRIPTION
This routine finds a symbol table entry, given the value associated with
that entry.  If there is no entry whose value is equal, it returns the
entry whose value is just lower than the given value.
The symbol name returned is up to pTbl->maxSymLen characters in length,
plus a terminating EOS.  It also sets the type and the actual value
of the symbol found.

.SH RETURNS
OK or ERROR if val < lowest value in the table
.SH SEE ALSO
symLib(1)
