.TH sscanf 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
sscanf - obtain values for arguments from ASCII string
.SH SYNOPSIS
.CS
.nf
int sscanf (str, fmt, args)
    char *str;    /* string to decode                     */
    char *fmt;    /* the format string                    */
    int args;     /* optional arguments to sscanf         */
.fi
.CE
.SH DESCRIPTION
Reads characters from string str, interprets them according to formats
in string fmt, and assigns values to arguments starting with that
pointed at by arg.

This routine is similar to the UNIX/K&R standard.  Tutorial info may be
found in the UNIX documentation, and in Kernighan & Ritchie's C
manual.

.SH FORMAT STRING

The format string may contain:

    White-space characters (space, tab, carriage return, newline,
    or formfeed) which are ignored.

    Ordinary characters (not %) which are expected to match the
    next non-white-space character in the string str.

    Conversion specifications are of the following form:
.CS
       [%<*><n><h|l>[c|d|e|f|E|F|g|o|u|x|s|[...]]

      <*>   - optional suppress assignment.
      <n>   - an optional number specifying a maximum
              fieldwidth.
      <h|l> - an optional character indicating that the
              value converted is to be assigned to a
              short (h) or long (l) integer or a double (l)
              precision float.

   [c|d|e|f|E|F|g|o|u|x|s|[...]] - conversion character.
              c - a character is expected in the input,
                  the corresponding argument should be
                  a character pointer.  If a field width
                  is given the argument should be an array.
              d - a decimal integer is expected in the 
                  input; the corresponding argument should
                  be a pointer to a (possibly short or long)
                  integer.
      e|f|E|F|g - a floating point number is expected;
                  corresponding argument should be a pointer
                  to a float, or double if E, F, or preceding l.
              o - an octal integer is expected in the input;
                  the corresponding argument should be a
                  pointer to a (possibly short of long)
                  integer.
              u - a decimal integer is expected in the input;
                  the corresponding argument should be a
                  pointer to an unsigned (possibly short
                  or long) integer.
              x - a hexadecimal integer is expected in the
                  input; the corresponding argument should be
                  be a pointer to a (possibly short or long)
                  integer.
              s - a character string is expected, delimited
                  by white space, a fieldwidth specification,
                  or an EOS; the corresponding argument should
                  be a character pointer, pointing to a char-
                  acter array large enough to accept both the
                  string and a terminating NULL, which will
                  be added.
              [...] - a character string is expected,
                  delimited by any character not contained
                  in the bracketed string.  The left bracket
                  is followed by a set of characters and a right
                  bracket.  The characters between the brackets
                  define a set of characters making up the string.
                  If the first character is not circumflex (^),
                  the input field is all characters until the
                  first character not in the set between the
                  brackets.  If the first character after the
                  left bracket is  ^ , the input field is all
                  characters until the first character which
                  is in the remaining set of characters between
                  the brackets.  Ranges of the form "a-z" are
                  allowed in the bracketed set.  The special
                  characters '^' and ']' can be included in the
                  set by making them the first characters in it.
                  The corresponding argument should be a
                  character pointer, pointing to a character
                  array large enough to accept both the string
                  and a terminating NULL, which will be added.
.CE
White space characters in the string to be decoded are ignored, except
insofar as they serve to delimit substrings to be decoded. Conversion
proceeds until complete, or something cannot be decoded according to
the format specification. Arguments for which a value can't be decoded
are left unchanged.

.SH RETURNS
number of arguments to which values have been successfully assigned

.SH DIFFERENCES FROM UNIX
This sscanf will stop reading a %s string when the maximum field
width is reached.

.SH SEE ALSO
fioLib(1),
UNIX scanf, Kernighan & Ritchie C manual

