.TH rt11Open 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rt11Open - open a file on an RT-11 volume
.SH SYNOPSIS
.CS
.nf
RT_FILE_DESC *rt11Open (vdptr, name, mode)
    RT_VOL_DESC *vdptr; /* pointer to volume descriptor         */
    char *name;         /* RT-11 filename (ffffff.ttt)          */
    int mode;           /* file mode (READ/WRITE/UPDATE)        */
.fi
.CE
.SH DESCRIPTION
This routine opens the file `name' with the specified mode.
The volume directory is searched, and if the file is found
an RT-11 file descriptor is initialized for it.

The directory currently in memory for the volume is used unless
there has been a ready change (rt11ReadyChange (2)) or this is the very first
open. If that is the case, the directory will be read from the disk
automatically.

A null file name is treated specially, to open an entire disk.
In this case, no attempt is made to access the disk's directory, so that
even un-initialized disks may be accessed.

.SH RETURNS
   Pointer to RT-11 file descriptor, or
   NULL if volume not available or
           no more RT-11 fd's available or
           no such file.
.SH SEE ALSO
rt11Lib(1)
