.TH rt11Ioctl 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rt11Ioctl - do device specific control function
.SH SYNOPSIS
.CS
.nf
STATUS rt11Ioctl (pFd, function, arg)
    RT_FILE_DESC *pFd; /* file descriptor of file to control   */
    int function;      /* function code                        */
    int arg;           /* some argument                        */
.fi
.CE
.SH DESCRIPTION
This routine performs the following ioctl (2) functions:

.CS
   FIODISKINIT:   Initialize the disk volume.  This routine does not
                  format the disk, this must be done by the driver.
   FIODIRENTRY:   Returns pointer to the next dir entry, into
                  the REQ_DIR_ENTRY pointed to by arg.
   FIORENAME:     Rename the file to the string pointed to by arg.
   FIOSEEK:       Sets the file's current byte position to
                  the position specified by arg.
   FIOWHERE:      Returns the current byte position in the file.
   FIOFLUSH:      Flush file output buffer.
                  Guarantees that any output that has been requested
                  is actually written to the device.
   FIONREAD:      Return in arg the number of unread bytes.
   FIODISKCHANGE: Indicate media change.  See rt11ReadyChange(2).
   FIOSQUEEZE:    Reclaim fragmented free space on RT-11 volume
.CE

If an ioctl fails, the task's status (see errnoGet (2)) indicates
the nature of the error.

.SH RETURNS
   OK, or
   ERROR if function failed or unknown function, or
   current byte pointer for FIOWHERE.
.SH SEE ALSO
rt11Lib(1)
