.TH rt11DevInit 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rt11DevInit - initialize RT-11 device descriptor
.SH SYNOPSIS
.CS
.nf
STATUS rt11DevInit (vdptr, bytesPerSec, secPerTrack, nSectors, 
             rt11Fmt, nEntries, rdSec_func, wrtSec_func, reset_func)
    RT_VOL_DESC *vdptr;  /* pointer to volume descriptor         */
    int bytesPerSec;     /* number of bytes per physical sector  */
    int secPerTrack;     /* number of sectors per track          */
    int nSectors;        /* number of sectors on device          */
    BOOL rt11Fmt;        /* TRUE iff device is to be accessed    */
                         /* using RT-11 track skew & interleave  */
    int nEntries;        /* number of directory entries for this */
                         /* volume, including terminating entry  */
    FUNCPTR rdSec_func;  /* function to read a sector from       */
                         /* this device                          */
    FUNCPTR wrtSec_func; /* function to write a sector to        */
                         /* this device                          */
    FUNCPTR reset_func;  /* function to reset device             */
.fi
.CE
.SH DESCRIPTION
This routine initializes the device descriptor.  The parameters bytesPerSec,
secPerTrack, and nSectors describe the physical format of the device.
rt11Fmt is TRUE iff the device is to be accessed using standard RT-11 skew
and interleave.
The function passed as rdSec_func will be called whenever sectors
need to be read from the device, wrtSec_func will be called
whenever sectors need to be written, and reset_func will be called when the
device needs to be reset (after a volume change, for instance).  None of
these functions will be called from rt11DevInit.

The device's directory will consist of one segment able to contain at
least as many files as specified by nEntries.
If nEntries is RT_FILES_FOR_2_BLOCK_SEG, then strict RT-11 
compatibility is maintained.

.SH NOTE
An ERROR will be returned if rt11Fmt is TRUE and sectors/track is odd.
This is because an odd number of sectors/track is incompatible with the
RT-11 interleaving algorithm.  

.SH RETURNS
   OK, or
   ERROR if invalid device parameters were specified, or out of memory.
.SH SEE ALSO
rt11Lib(1)
