.TH rt11Create 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rt11Create - create an RT-11 file
.SH SYNOPSIS
.CS
.nf
RT_FILE_DESC *rt11Create (vdptr, name, mode)
    RT_VOL_DESC *vdptr; /* pointer to volume descriptor         */
    char *name;         /* RT-11 string (ffffff.ttt)            */
    int mode;           /* file mode (READ/WRITE/UPDATE)        */
.fi
.CE
.SH DESCRIPTION
This routine creates the file `name' with the specified mode.
If the file already exists, it is first deleted then recreated.
The largest empty space on the device is allocated to the new file.
Excess space will be recovered when the file is closed.
An RT-11 file descriptor is initialized for the file.

A file name of zero length, i.e. "" is used to open an entire "raw" disk.
In this case, no attempt is made to access the disk's directory, so that
even un-initialized disks may be accessed.

.SH RETURNS
   Pointer to RT-11 fd, or
   NULL if error in create.
.SH SEE ALSO
rt11Lib(1)
