.TH routeAdd 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
routeAdd - add a route
.SH SYNOPSIS
.CS
.nf
STATUS routeAdd (destination, gateway)
    char *destination; /* inet address or name of route destination     */
    char *gateway;     /* inet address or name of gateway to destnation */
.fi
.CE
.SH DESCRIPTION
routeAdd updates the routing tables to include a gateway to the 
given destination.  It is called from the VxWorks machine which needs
access to the destination network (or machine) through a gateway.

The "destination" and "gateway" may be specified either by their internet
addresses in standard internet address format (eg "90.0.0.2"), or by their
names (eg "hostname") which have already been added to the remote host
table (with hostAdd).

.SH EXAMPLE
The call:
.CS
      routeAdd ("90.0.0.0", "gate")
.CE
tells VxWorks that the machine with the host name "gate" is our gateway to
the "90.0.0.0" net.  The host "gate" must already have been created by
hostAdd(2).

The call:
.CS
      routeAdd ("90.0.0.0", "91.0.0.3")
.CE
tells VxWorks that the machine with the Internet address "91.0.0.3" is our
gateway to the "90.0.0.0" net.

The call:
.CS
      routeAdd ("destination", "gate")
.CE
tells VxWorks that the machine with the host name "gate" is our gateway to
the machine refered to as "destination".  The host names "gate" and
"destination" must have already been created by hostAdd(2).

.SH RETURNS
OK or ERROR

.SH SEE ALSO
routeLib(1)
