.TH rngPutAhead 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rngPutAhead - put a byte ahead in ring buffer without moving ring pointers
.SH SYNOPSIS
.CS
.nf
VOID rngPutAhead (ringId, byte, offset)
    RING_ID ringId;      /* ring buffer to put byte in    */
    char byte;           /* byte to be put in ring        */
    int offset;          /* offset beyond next input byte */
                         /* where to put byte             */
.fi
.CE
.SH DESCRIPTION
This routine writes a byte into the ring, but doesn't move the ring buffer
pointers.  Thus the byte will not yet be available in the ring by
rngBufGet (2) calls.  The byte is written `offset' bytes ahead of the next
input location in the ring.  Thus an offset of 0 puts the byte in the same
place that RNG_ELEM_PUT would put a byte, except that the input pointer is not
updated.

Bytes written ahead in the ring buffer with this routine can be made available
all at once by subsequently moving the ring buffer pointers with the routine
rngMoveAhead (2).

It is up the caller to verify that at least `offset' + 1 bytes are available
in the ring buffer, before calling this routine.
.SH SEE ALSO
rngLib(1)
