.TH recvfrom 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
recvfrom - receive a datagram
.SH SYNOPSIS
.CS
.nf
int recvfrom (s, buf, len, flags, from, fromlen)
    int s;                 /* socket on which to receive data */
    caddr_t buf;           /* pointer to data buffer */
    int len;               /* length of buffer */
    int flags;             /* flags to underlying protocols */
    struct sockaddr *from; /* get's filled in with sender's address */
    int *fromlen;          /* should contain length of from when called,*/
                           /* get's filled in with actual length of */
                           /* address on return */
.fi
.CE
.SH DESCRIPTION
recvfrom is used to receive data from a socket regardless of whether it
is connected or not.  If `from' is non-zero, the source address of the
message is filled in.  The parameter `fromlen' should be initialized
to the size of the `from' buffer.  On return, it contains the actual
size of the address stored.

.SH RETURNS
 number of bytes received, or
 ERROR if receive failed
.SH SEE ALSO
sockLib(1)
