.TH ramMkfs 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ramMkfs - create a ram disk device with an RT-11 file system
.SH SYNOPSIS
.CS
.nf
STATUS ramMkfs (name, nbytes, where, dontInit)
    char *name;    /* Device name                          */
    int nbytes;    /* Number of bytes total for ram disk   */
    char *where;   /* Where it is in memory (0 = malloc)   */
    BOOL dontInit; /* FALSE = initialize RT-11 directory;  */
                   /* TRUE  = don't                        */
.fi
.CE
.SH DESCRIPTION
This routine provides a convenient way to create and initialize
ram disks with standard parameters.  The device is created with the
specified name and size.  If no memory address is specified,
then memory for the ram disk will be allocated from the pool.
Unless 'dontInit' is specified TRUE, an RT-11 directory will be
initialized on the newly created device.

The ram devices created by this routine have 512 byte "sectors",
1 "track", do not have "RT-11 compatible skew and interleave",
and have 0 sector offset (see ramDevCreate for details).

.SH EXAMPLE
The shell command:
      -> ramMkfs "/ram/",200000
creates a ram device named "/ram/" with 200000 bytes of memory
allocated from the pool, and initializes an RT-11 directory on it.

The shell command:
      -> ramMkfs "/ram/",200000,0xc0000,1
creates a ram device whose starting address is 0xc0000 and does
NOT initialize an RT-11 directory on it.  This might be useful
if a ram disk was created at that same address in a previous
boot of VxWorks.  The contents of the ram disk would be unchanged.

.SH RETURNS
OK | ERROR
.SH SEE ALSO
ramDrv(3)
