.TH printf 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
printf - print formatted string to standard output
.SH SYNOPSIS
.CS
.nf
VOID printf (fmt, args)
    char *fmt;          /* format string for print      */
    int args;           /* optional arguments to format */
.fi
.CE
.SH DESCRIPTION
This routine prints formatted strings to standard output.  Fmt is a string
containing two types of objects; plain characters, which are simply copied
to standard output, and conversion specifications, each of which causes
conversion and printing of the next argument from the list of arguments
which follow fmt.  There may be an arbitrary number of args, but there
must be at least as many as are needed by the format string.

This routine is compatible with the UNIX/K&R standard printf, except
for minor differences.  Tutorial info can be found in the
Kernighan & Ritchie C manual, or in the UNIX documentation.

.SH FORMAT STRING
The format string contains normal ASCII text, which will be passed
through as is, except for special conversion specifications of the
following form:

.CS
       %<-><+><sp><#><n><.n><l>[d|e|f|g|o|x|u|c|s|b]

   -  - left adjust converted argument in its field.
   +  - result of a signed conversion will always begin
        with a sign.
  sp  - result of a signed conversion will always begin
        with a sign or blank if positive.
   #  - result is printed in alternate form.
   n  - minimum field width.
        If converted argument is shorter than this, it will
        be padded on the left (or right if left adjustment
        is indicated). Padding character is blank normally,
        and zero if field width was specified with a leading
        zero.  If '*', get fieldwidth from arg, main arg
        follows.  '0*' is permissible.  A '*' eats an arg
        in addition the argument being converted.

   .n - maximum field width.
        If '*', get fieldwidth from arg, main arg follows.
        A '*.*' eats 2 args in addition the argument being
        converted.

   l  - indicates that corresponding data item is a long
        rather than an int.

   [d|e|f|o|x|u|c|s] - conversion character.
      d       - argument is converted to signed decimal
                notation.
      e       - argument is a float; printed in the style
                [-]d.ddde+dd where there is one digit before
                the decimal point and the number after is
                equal to the precision specification for the
                argument.  When the precision is missing,
                six digits are produced. If preceded by an l
                then argument is a double.
      f       - argument is a float; printed in the style
                [-]ddd.ddd where the number of ds after the
                decimal point is equal to the precision
                specification for the argument.  If the
                precision is missing, six digits are given;
                if the precision is explicitly 0, no digits
                and no decimal point are printed. If
                preceded by an l then argument is a double.
      g       - uses either e or f whichever is more compact.
      o       - argument is converted to unsigned octal
                notation.
      x       - argument is converted to unsigned
                hexadecimal notation.
      u       - argument is converted to unsigned decimal
                notation.
      c       - argument is a single character.
      s       - argument is a string; characters printed
                until a null, or maximum field width is
                reached.
      b       - argument is a buffer; characters printed
                until minimum field width is reached.

.CE
.SH DIFFERENCES FROM UNIX PRINTF

This printf has the `b' format specification.
Otherwise the two are source compatible.

.SH SEE ALSO
fioLib(1),
UNIX printf manual entry, Kernighan & Ritchie C manual

