.TH pathCat 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
pathCat - concatenate directory path to file name
.SH SYNOPSIS
.CS
.nf
VOID pathCat (dirName, fileName, result)
    char *dirName;  /* directory path */
    char *fileName; /* filename to be added to end of path */
    char *result;   /* where to form concatenated name */
.fi
.CE
.SH DESCRIPTION
This routine constructs a valid UNIX file name from a directory path
and a file name.  The directory name may or may not start with a device name.
The file name is a bit of a misnomer since it may or may not be prepended
with directory names.  Usually, all that is necessary is to insert a
slash ('/') between the directory and file name, however exceptional
cases are also handled.

If the fileName begins with a '/', '~', or '$', the result will be the
file name, unless the directory name (dirName) begins with a device name.
In the case that dirName begins with a device name, the file name is
inserted after the device name part of dirName.

If the directory path is just a device name, and the device name does not
end with a '/' or ':', AND the file name does not start with a '/', '~',
or '$', then a slash ('/') is inserted between the device name and the 
file name.  This implementation originated for use with NFS devices in which
full file names emulate UNIX style names.

.SH RETURNS
the resultant path name in `result'
.SH SEE ALSO
pathLib(1)
