.TH nfsMount 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
nfsMount - mount an NFS directory
.SH SYNOPSIS
.CS
.nf
STATUS nfsMount (host, fileSystem, localName)
    char *host;       /* name of remote host                    */
    char *fileSystem; /* name of remote directory to mount      */
    char *localName;  /* local device name for remote directory */
                      /* (NULL = use fileSystem name)           */
.fi
.CE
.SH DESCRIPTION
This routine creates a local name for a remote directory.  This is done
by creating a device with name `localName', that refers to the
remote directory `fileSystem' on the specified host.
The host must have already been created with a hostAdd (2) call.
If `localName' is NULL then the local device name will be the
same as the `fileSystem' name.

.SH SEE ALSO
nfsDrv(3),
nfsUnmount (2), hostAdd (2)

.SH RETURNS
OK or ERROR if driver not installed, invalid host or out of memory
