.TH nfsHelp 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
nfsHelp - help command for NFS
.SH SYNOPSIS
.CS
.nf
VOID nfsHelp ()
.fi
.CE
.SH DESCRIPTION
Print a brief synopsis of NFS facilities that are typically called from
the shell.
.CS
 nfsHelp                       Print this list
 netHelp                       Print general network help list
 nfsMount "host","filesystem"[,"devname"]  Create device with
                                 filesystem/directory from host
 nfsUnmount "devname"          Remove an NFS device           
 nfsAuthUnixShow               Print current UNIX authentication
 nfsAuthUnixPrompt             Prompt for UNIX authentication
 nfsDevShow                    Print list of NFS devices
 nfsExportShow "host"          Print a list of NFS file systems which
                                 are exported on the specified host
 mkdir "dirname"               Create directory
 rm "file"                     Remove file
 
 EXAMPLE:  -> hostAdd "wrs", "90.0.0.2"
           -> nfsMount "wrs","/disk0/path/mydir","/mydir/"
           -> cd "/mydir/"                                 
           -> nfsAuthUnixPrompt     /* fill in user id, etc. *
           -> ls                    /* list /disk0/path/mydir *
           -> copy < foo            /* copy foo to standard out *
           -> ld < foo.o            /* load object module foo.o *
           -> nfsUnmount "/mydir/"  /* remove NFS device /mydir/ *
.CE
.SH SEE ALSO
nfsLib(1)
