.TH loadModuleAt 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
loadModuleAt - load object module into memory
.SH SYNOPSIS
.CS
.nf
STATUS loadModuleAt (fd, symFlag, ppText, ppData, ppBss)
    int fd;        /* fd from which to read module */
    int symFlag;   /* symbols to be added to table 
                    *   ([NO | GLOBAL | ALL]_SYMBOLS) */
    char **ppText; /* load text segment at adress pointed to by this
                    * pointer, return load address via this pointer */
    char **ppData; /* load data segment at adress pointed to by this
                    * pointer, return load address via this pointer */
    char **ppBss;  /* load bss segment at adress pointed to by this
                    * pointer, return load address via this pointer */
.fi
.CE
.SH DESCRIPTION
This routine reads an a.out format object module from the specified
fd, and loads the code, data and bss into memory at the specified
load addresses, or into allocated memory as described below.
The module is properly relocated as per the relocation commands in the file.
Unresolved externals will be linked to symbols found in the system
symbol table.  Symbols in the module being loaded can optionally
be added to system symbol table.

.SH LINKING UNRESOLVED EXTERNALS
As the module is loaded, any unresolved external references are resolved
by looking up the missing symbols in the the system symbol table.
If found, those references are correctly linked to the new module.
If unresolved external references can not be found in the system symbol
table, then an error message ("undefined symbol: ...") is printed for
the symbol but the loading/linking continues.  In this case, ERROR will
be returned after the module is loaded.

.SH ADDING SYMBOLS TO THE SYMBOL TABLE
The symbols defined in the module being loaded may optionally be added
to the system symbol table, depending on the value of symFlag:

   symFlag            symbols that will be added to system symbol table
   --------------     -------------------------------------------------
   NO_SYMBOLS         none
   GLOBAL_SYMBOLS     external symbols only
   ALL_SYMBOLS        all symbols

In addition, the following symbols are also added to the symbol table
to indicate the the start of each segment:
<filename>_text, <filename>_data, and <filename>_bss
-- where "filename" is the name associated with the fd.

.SH RELOCATION
The relocation commands in the object module are used to relocate
the text, data, and bss segments of the module.  The location of each
segment can be specified explicitly, or left unspecified in which
case memory will be malloc'ed for the segment from the system memory pool.
This is determined by the parameters ppText, ppData, and ppBss
each of which can have the following values:

  NULL                 = no load address is specified, none will be returned
  ptr to LD_NO_ADDRESS = no load address is specified, return address via ptr
  ptr to address       = load address is specified

The ppText, ppData, and ppBss parameters are delightfully devious.
For each one, if the pointer is NULL, the caller doesn't care where the
segment gets loaded, and doesn't want to be told.  If the pointer is not
NULL, then the pointer points to a second pointer, which points to where
the segment should be loaded.  If that second pointer has the value
LD_NO_ADDRESS, then the caller doesn't care where the segment gets loaded,
but wishes to be told where it was put.  In that case, the LD_NO_ADDRESS
gets replaced with a pointer to where the segment got loaded.
(LD_NO_ADDRESS is used, rather than NULL, so that a segment may be loaded
at the beginning of memory.)

When either don't care method is used, the corresponding segment is placed
following the preceding segment (where the ordering of segments is text,
data, bss). Thus, if ppText is don't care, ppData indicates an actual
address, and ppBss is don't care, then space will be allocated for text,
and bss will be placed following data. The caller is responsible for
ensuring that the area indicated by ppData is large enough to contain
both data and bss.

.SH COMMON
Some host compiler/linker combinations internally use another storage
class called "common".  In "C", uninitialized global variables are
eventually put in the BSS segment.  However, in partially linked object
modules they are flagged internally as "common" and the UNIX linker
resolves these and places them in BSS as a final step in creating a
fully linked object module.  However, the VxWorks loader is most often
used to load partially linked object modules.  When the VxWorks loader
encounters a variable labeled as "common", memory for the variable
is allocated (with malloc) and the variable is entered in the system
symbol table (if specified) at that address.  Note that most UNIX
loaders have an option that forces resolution of the "common" storage
while leaving the module relocatable
(e.g. with typical BSD UNIX loaders, use options "-rd").

.SH EXAMPLE

Load a module into allocated memory; don't return segment addresses:

  status = loadModuleAt (fd, GLOBAL_SYMBOLS, NULL, NULL, NULL);

Load a module into allocated memory; return segment addresses:

  pText = pData = pBss = LD_NO_ADDRESS;
  status = loadModuleAt (fd, GLOBAL_SYMBOLS, &pText, &pData, &pBss);

Load a module at a specified address:

  pText = 0x800000;                   /* address of text segment *
  pData = pBss = LD_NO_ADDRESS        /* other segments follow by default *
  status = loadModuleAt (fd, GLOBAL_SYMBOLS, &pText, &pData, &pBss);

.SH RETURNS
 OK, or
 ERROR if can't read file or not enough memory or illegal file format

.SH SEE ALSO
loadLib(1),
"Architecture", UNIX manual for a.out format
