.TH ld 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ld - load object module into memory
.SH SYNOPSIS
.CS
.nf
STATUS ld (syms, noAbort)
    int syms;       /* -1, 0, or 1 */
    BOOL noAbort;   /* TRUE = don't abort script on error */
.fi
.CE
.SH DESCRIPTION
This routine loads an object module from standard in.  That object module is
expected to be in UNIX a.out format.  As the module is loaded, any external
references in it will be resolved. If (syms == 0), global symbols defined
in the module will be added to the system symbol table.  If (syms == 1),
globals and locals will be added to the table.  If (syms == -1), no
symbols will be added.

If there is an error on the load (externals undefined, too many symbols,
etc), shellScriptAbort will normally be called, to stop any script that
this routine was called from.  If noAbort == TRUE, errors are noted but
ignored.

The normal way of using ld is to load all symbols (syms == 1) during debug,
and only global symbols later.

.SH EXAMPLE
.CS
 ld <module    - Loads a.out file "module" from the default file
                 device into memory, and puts any global symbols
                 it defines into the symbol table
.CE

.SH RETURNS
   OK, or
   ERROR if too many symbols,
   invalid object file format, or
   error reading file

.SH SEE ALSO
usrLib(1),
loadLib (1)
