.TH l 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
l - print a number of disassembled instructions
.SH SYNOPSIS
.CS
.nf
VOID l (addr, count)
    INSTR *addr; /* Address of first instruction to disassemble, */
                 /* if 0, continue from the last instruction     */
                 /* disassembled on the last call to l.          */
    int count;   /* Number of instruction to disassemble,        */
                 /* if 0, use the same as the last call to l.    */
.fi
.CE
.SH DESCRIPTION
This routine is intended to be called from the VxWorks shell.
It dissasembles some number of instructions and prints them on standard out.
If the address of an instruction is entered in the system symbol table,
the symbol will be printed as a label for that instruction.
Also, addresses in the op-code field of instructions will be printed
symbolically.

The format of the shell call is
.CS
 -> l [address [,count]]
.CE
If address is not given, disassembly continues from the previous address.
If count is not given, the last specified count is used (initially 10).
As with all values entered via the shell, the address may be typed 
symbolically.

.SH SEE ALSO
dbgLib(1),
"Debugging", dsmLib(1)
