.TH intConnect 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
intConnect - connect C routine to hardware interrupt
.SH SYNOPSIS
.CS
.nf
STATUS intConnect (vector, routine, parameter)
    FUNCPTR *vector; /* interrupt vector to attach to */
    FUNCPTR routine; /* routine to be called */
    int parameter;   /* parameter to be passed to routine */
.fi
.CE
.SH DESCRIPTION
This routine connects the specified C routine to the specified
interrupt vector.  When an interrupt occurs that vectors through
the specified address, the routine will be called with the specified
parameter.  The routine will be invoked in supervisor mode at interrupt
level.  A proper C environment will have been established,
the necessary registers saved, and the stack set up.

The routine can be any normal C code, except that it must not
invoke certain operating system functions.

This routine simply calls intHandlerCreate (2) and intVecSet (2).
It is the address of the handler returned by intHandlerCreate (2)
that actually gets put in the interrupt vector.

.SH RETURNS
   OK or
   ERROR if unable to build interrupt handler

.SH SEE ALSO
intLib(1),
intHandlerCreate (2), intVecSet (2)
