.TH hostAdd 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
hostAdd - add a host to the host table
.SH SYNOPSIS
.CS
.nf
STATUS hostAdd (hostName, hostAddr)
    char *hostName; /* host name */
    char *hostAddr; /* host address in standard internet format */
.fi
.CE
.SH DESCRIPTION
This command is used to add a hostname to the local host table.
This must be called before sockets on the remote host are opened,
or files on the remote host are accessed via netDrv (3) or nfsDrv (3).

The host table has one entry per internet address.
More than one name may be used for an address.
Additional host names are added as aliases.

.SH EXAMPLE
.CS
   -> hostAdd "wrs", "90.2"
   -> hostShow
   hostname         inet address       aliases
   --------         ------------       -------
   localhost        127.0.0.1         
   yuba             90.0.0.3          
   wrs              90.0.0.2          
   value = 12288 = 0x3000 = _bzero + 0x18
   -> 
.CE
.SH RETURNS
 OK, or
 ERROR if host table full,
 host name already entered,
 invalid inet address, or
 out of memory
.SH SEE ALSO
hostLib(1)
