.TH ftpXfer 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ftpXfer - initiate transfer via FTP
.SH SYNOPSIS
.CS
.nf
STATUS ftpXfer (host, user, passwd, acct, cmd, dirname, filename,
            pCtrlSock, pDataSock)
    char *host;     /* name of server host */
    char *user;     /* user name with which to login to host */
    char *passwd;   /* password with which to login to host */
    char *acct;     /* account with which to login to host */
    char *cmd;      /* command to send to host */
    char *dirname;  /* directory to 'cd' to before sending command */
    char *filename; /* filename to send with command */
    int *pCtrlSock; /* where to return control socket fd */
    int *pDataSock; /* where to return data socket fd,
                     * (NULL == don't open data connection) */
.fi
.CE
.SH DESCRIPTION
This routine is used to initiate a transfer via a remote FTP server.
It first establishes a connection to the FTP server on the specified host.
Then it logs in with the specified user name, password, and account,
as necessary for the particular host.
Next the transfer type is set to "image" by sending the "TYPE I" command,
and the directory is changed to the specified directory by sending
the "CWD <dirname>" command.  Finally, the specified transfer command
is sent with the specified filename as an argument, and a data connection
is established.  The resulting control and data connection fds are returned
via pCtrlSock and pDataSock respectively.
Typical transfer commands would thus be "STOR %s" to write to a remote file,
or "RETR %s" to read a remote file.

After calling this routine, the data can be read or written to the remote
server by reading or writing on the fd returned in pDataSock.
When all incoming data has been read (as indicated by an EOF when reading
the data socket) and/or all outgoing data has been written, the data
socket fd should be closed.
Then the routine ftpReplyGet (2) should be called to receive the final reply
on the control socket.
Finally, the control socket should be closed.

If the FTP command being invoked involves no data transfer (i.e. file
delete or rename), pDataSock should be specified NULL, in which case
no data connection will be established.

.SH EXAMPLE
The following code fragment reads the file "/usr/fred/myfile" from the
host "server", logged in as user "fred" with password "magic" and no
account name.

.CS
  int ctrlSock;
  int dataSock;
  char buf [512];
  int nBytes;

  if (ftpXfer ("server", "fred", "magic", "",
               "RETR %s", "/usr/fred", "myfile",
               &ctrlSock, &dataSock) == ERROR)
      return (ERROR);

  while ((nBytes = read (dataSock, buf, sizeof (buf))) > 0)
      {
      ...
      }

  close (dataSock);

  if (nBytes < 0)             /* read error? *
      status = ERROR;

  if (ftpReplyGet (ctrlSock) != FTP_COMPLETE)
      status = ERROR;

  close (ctrlSock);
.CE

.SH RETURNS
 OK, or
 ERROR, if any socket can't be created, or connection can't be made

.SH SEE ALSO
ftpLib(1),
ftpReplyGet (2)
