.TH ftpDataConnInit 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
ftpDataConnInit - initialize FTP data connection
.SH SYNOPSIS
.CS
.nf
int ftpDataConnInit (ctrlSock)
    int ctrlSock;      /* fd of associated control socket */
.fi
.CE
.SH DESCRIPTION
This routine sets up the client side of a data connection for the
specified control connection.  It creates the data port, informs the
remote FTP server of the data port address, and initiates a 'listen'
on that data port.  The server will then connect to this data port
in response to a subsequent data-transfer command sent on the
control connection (see ftpCommand (2)).
This routine must be called BEFORE the data-transfer command is sent
or the server's connect may fail.

This routine is typically called after calling ftpHookup (2) and ftpLogin (2)
to establish a connection with a remote FTP server at the lowest level.
(For a higher level interaction with a remote FTP server, see ftpXfer (2)).

.SH RETURNS
fd of data socket created, or ERROR

.SH SEE ALSO
ftpLib(1),
ftpHookup (2), ftpLogin (2), ftpCommand (2), ftpXfer (2)
