.TH freopen 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
freopen - substitute named file in place of the open stream
.SH SYNOPSIS
.CS
.nf
FILE *freopen (filename, type, fp)
    char *filename;     /* new file to open  */
    char *type;         /* mode to open file */
    FILE *fp;           /* old stream        */
.fi
.CE
.SH DESCRIPTION
The original stream is closed.  The new file is opened in its place.

Typically used to substitute a file in place of the standard
preopened streams stdin, stdout, and stderr.

A file may be changed from unbuffered or line buffered
to block buffered by using freopen.
A file can be changed from block buffered or line buffered
to unbuffered by using freopen followed by setbuf with a
NULL buffer argument.

.SH RETURNS
   original value of stream, or
   NULL if unable to open file

.SH SEE ALSO
stdioLib(1),
fopen(2), fdopen(2)
