.TH fppTaskRegsGet 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
fppTaskRegsGet - get a task's floating-point registers from TCB
.SH SYNOPSIS
.CS
.nf
STATUS fppTaskRegsGet (task, fpregs, pFpcr, pFpsr, pFpiar)
    int task;           /* task to get info about         */
    double fpregs[];    /* floating-point registers (0-7) */
    int *pFpcr;         /* control register               */
    int *pFpsr;         /* status register                */
    int *pFpiar;        /* instruction address register   */
.fi
.CE
.SH DESCRIPTION
This routine returns, in the locations whose pointers are
passed as parameters, the task's floating-point registers and its
PCR, PSR and PIAR.  The floating-point registers are returned in
an array containing the 8 registers.

.SH NOTE
This routine only works well if the specified task is not that
of the calling task.  If a task tries to discover its own registers,
the values will be stale, i.e. leftover from the last task switch.

.SH RETURNS
OK or ERROR if no floating-point support or invalid state

.SH SEE ALSO
fppLib(1),
fppTaskRegsSet(2)
