.TH fioFormat 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
fioFormat - format processor
.SH SYNOPSIS
.CS
.nf
VOID fioFormat (fmt, arg_list, routine, outarg)
    char *fmt;       /* format string                                */
    int *arg_list;   /* list of arguments to be converted to ASCII   */
    FUNCPTR routine; /* routine to handle args as they're decoded    */
    int outarg;      /* argument to routine                          */
.fi
.CE
.SH DESCRIPTION
This routine is used by printf (2), sprintf (2), bprintf (2), and fdprintf (2)
to handle the actual conversion of a format string.  The
first argument is a format, as described in the entry for printf (2).
The second argument
is a pointer to the first argument to be used in processing the
format string.  Other arguments should follow this argument directly
in memory, as would be the case in the normal C calling sequence on
the 680x0.

As the format string is processed, it will be passed to the routine whose
address is passed as the third  parameter, which may output it to a
device, put it in a buffer, or whatever.  The routine should be declared
as follows:

.CS
      outRoutine (buffer, nchars, outarg)
          char *buffer;      /* buffer passed to routine      *
          int nchars;        /* length of buffer              *
          int outarg;        /* arbitrary argument passed to  *
                             /* format routine                *
.CE
outarg may be an fd, a buffer address, or whatever (but not a structure).

.SH SEE ALSO
fioLib(1)
