.TH etherInputHookAdd 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
etherInputHookAdd - add routine to receive all ethernet input packets
.SH SYNOPSIS
.CS
.nf
STATUS etherInputHookAdd (inputHook)
    FUNCPTR inputHook; /* routine to receive ethernet input */
.fi
.CE
.SH DESCRIPTION
This routine adds a hook routine that will be called for every ethernet
packet that is received.

Calling sequence of input hook routine:
.CS
 BOOL inputHook (pIf, buffer, length)
     struct ifnet *pIf; /* ptr to interface packet was received on *
     char *buffer;      /* ptr to received packet                  *
     int length;        /* length of received packet               *
.CE
The hook routine should return TRUE if it has handled the input packet and
no further action should be taken with it.  It should return FALSE
if it has not handled the input packet and normal (i.e. inet) processing
should take place.

The packet is in a temporary buffer when the hook routine is called.
This buffer will be reused upon return from the hook.
The hook routine should copy the input packet elsewhere if it needs
to retain it.

.SH IMPLEMENTATION
To effect the hook, a call out to etherInputHook should be included
in the receive routine of every network driver that is to be included
in this mechanism.

.SH RETURNS
OK (always)
.SH SEE ALSO
etherLib(1)
