.TH dsmInst 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
dsmInst - disassemble and print a single instruction
.SH SYNOPSIS
.CS
.nf
int dsmInst (binInst, address, prtAddress)
    USHORT *binInst;    /* Pointer to the instruction */
    int address;        /* Address prepended to instruction */
    FUNCPTR prtAddress; /* Address printing function */
.fi
.CE
.SH DESCRIPTION
This routine is called to disassemble and print (on standard out) a
single instruction.  The function passed as parameter prtAddress will
be used to print any operands which might be construed as addresses.
This could be either a simple routine that just prints a number,
or one that looks up the address in a symbol table.
The disassembled instruction will be prepended with the address
passed as a parameter.

If prtAddress == 0, a default routine will be used that prints 
addresses as hex numbers.

.SH RETURNS 
The number of 16-bit words occupied by the instruction.
.SH SEE ALSO
dsmLib(1)
