.TH creat 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
creat - create a file
.SH SYNOPSIS
.CS
.nf
int creat (name, mode)
    char *name;         /* name of the file to create */
    int mode;           /* file creation mode         */
                        /* (UNIX chmod style)         */
.fi
.CE
.SH DESCRIPTION
Create a new file named `name', and open it with the specified
`mode'.  This routine figures out which device the file is to be
created on, then calls that device driver's create routine to do
most of the actual work.  Therefore, much of what really transpires
here is device/driver dependent.

The `mode' parameter is used for the file descriptor, and is set as either
READ, WRITE, or UPDATE for the duration that the file is opened.
To create NFS files with a particular file mode of the UNIX chmod (2) type,
call open() with the file mode specified in the third argument.

.SH RETURNS
   File descriptor number, or
   ERROR if no filename specified,
            no such device,
            no more fd's available (see iosInit),
            or driver returns ERROR.

.SH SEE ALSO
ioLib(1),
"I/O System", open (2)
