.TH checkStack 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
checkStack - print a summary of each task's stack usage
.SH SYNOPSIS
.CS
.nf
VOID checkStack (taskNameOrId)
    int taskNameOrId; /* task name or task id, 0 = summarize all */
.fi
.CE
.SH DESCRIPTION
This routine prints a summary of each task's stack usage.
The summary includes the total stack size (SIZE), the current number
of stack bytes used (CUR), the maximum number of stack bytes used (HIGH), and
the number of bytes never used at the top of the stack
(MARGIN [== SIZE - HIGH]).

The maximum stack usage is determined by scanning down from the top of
the stack for the first byte whose value is not 0xee.  The VxWorks spawn 
routine initializes all bytes of a task's stack to 0xee before starting 
a task.

.SH DEFICIENCIES
It is possible for a task to write beyond the end of its stack, but
not write into the last part of its stack, which will be undetected
by checkStack.

.SH SEE ALSO
usrLib(1),
taskSpawn (2)
