.TH b 2 "" "VxWorks Reference Manual"
.ad b
.SH NAME
b - set breakpoint
.SH SYNOPSIS
.CS
.nf
STATUS b (addr, taskNameOrId, count, quiet)
    INSTR *addr;      /* where to set breakpoint, or         */
                      /* 0 = display all breakpoints         */
    int taskNameOrId; /* task for which to set breakboint,   */
                      /* 0 = set all tasks                   */
    int count;        /* number of passes before hit         */
    BOOL quiet;       /* TRUE = don't print debugging info,  */
                      /* FALSE = print debugging info        */
.fi
.CE
.SH DESCRIPTION
This routine is used to set or examine breakpoints. To see the list of
currently active breakpoints, call it without arguments:
.CS
 -> b
.CE
The list shows the address, task and passcount of each breakpoint.
The routines so(2) and cret(2) insert temporary breakpoints and are so marked.

To set a new breakpoint, call it with at least an address:
.CS
 -> b addr [,task [,passcount] [, quiet]]
.CE
If the task is zero or missing, the breakpoint will apply to all breakable
tasks. If the passcount is zero or missing, the breakpoint will happen every
time it is hit.
The breakpoint address may be specified numerically or symbolically, with
an optional offset.

If a passcount is specified, the break will not occur until the (count+1)th
time the breakpoint is hit by an eligible task. That is, it will ignore the
breakpoint the first 'count' times it is hit.

If quiet is specified, debugging information destined for the console
will be supressed when the breakpoint is hit.  This option is included
for use by external source code debuggers that handle the breakpoint
user interface themselves.

Individual tasks can be "unbreakable" in which case breakpoints that
otherwise would apply to a task are ignored.  Tasks can be spawned
"unbreakable" by specifying the VX_UNBREAKABLE task option.
Tasks can also be set "unbreakable" or "breakable" by setting or resetting
the VX_UNBREAKABLE task option with the routine taskOptionsSet(2).

.SH RETURNS
   OK, or
   ERROR if addr is odd, or in non-existent memory, or
   breakpoint table is full

.SH SEE ALSO
dbgLib(1),
bd (2), taskOptionsSet (2), "Debugging"
