.TH taskLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
taskLib.c - task management interface for the VxWorks kernel 
.SH SYNOPSIS
.nf
taskSpawn - spawn a task
taskCreate - create a task with stack at specified address
taskActivate - activate an already created task
taskDelete - delete a task
exit - exit a task
taskSuspend - suspend a task
taskResume - resume a task
taskRestart - restart a task
taskOptionsSet - change task options
taskOptionsGet - examine task options
taskPrioritySet - change priority of a task
taskPriorityGet - examine priority of a task
taskLock - disable task rescheduling
taskUnlock - enable task rescheduling
taskDelay - delay a task from executing
taskTcb - get the task control block for a task id
taskTcbX - get the task control block extension associated with a task ID
taskInfoGet - get pointer to task's task descriptor
taskName - get name associated with a task id
taskNameToId - lookup task id associated with a name
taskIsSuspended - check if a task is suspended
taskIsReady - check if a task is ready to run
taskStatusString - return the task's status as a string
taskIdDefault - default task id
taskIdSelf - get task id of running task
taskIdVerify - verify the existence of a task
taskIdListGet - get list of active task IDs
taskRegsGet - get a task's registers from TCB
taskRegsSet - set a task's registers 
taskRegsShow - print contents of a task's registers
taskSRSet - set task status register

int taskSpawn (name, priority, options, stacksize, entryAddress, arg1, ...
int taskCreate (name, priority, options, botOfStack, stksize, pTcb, ...
STATUS taskActivate (tid)
STATUS taskDelete (tid)
VOID exit (code)
STATUS taskSuspend (tid)
STATUS taskResume (tid)
int taskRestart (tid)
STATUS taskOptionsSet (tid, mask, newOptions)
STATUS taskOptionsGet (tid, pOptions)
STATUS taskPrioritySet (tid, newPriority)
STATUS taskPriorityGet (tid, pPriority)
STATUS taskLock ()
STATUS taskUnlock ()
STATUS taskDelay (ticks)
WIND_TCB *taskTcb (tid)
TCBX *taskTcbX (tid)
STATUS taskInfoGet (tid, pTaskDesc)
char *taskName (tid)
int taskNameToId (name)
BOOL taskIsSuspended (tid)
BOOL taskIsReady (tid)
STATUS taskStatusString (tid, pString)
int taskIdDefault (tid)
int taskIdSelf ()
STATUS taskIdVerify (tid)
int taskIdListGet (idList, maxTasks)
STATUS taskRegsGet (tid, dregs, aregs, sp, sr, pc)
STATUS taskRegsSet (tid, pDregs, pAregs, sp, sr, pc)
VOID taskRegsShow (tid)
STATUS taskSRSet (tid, sr)
.fi
.SH DESCRIPTION
This library provides a generic interface to the VxWorks kernel
task management routines.  Task management includes:

    - create, delete, suspend, resume, restart, prioritize tasks,
    - lock and unlock scheduling,
    - delay a task from running,
    - get and set tasks' registers,
    - get and set tasks' options,
    - find TCBs (task control blocks),
    - find TCBXs (task control block extensions),
    - find TDs (kernel independent task descriptors),
    - translate task ids to task names, and vice versa.

.SH INCLUDE FILE
taskLib.h

.SH SEE ALSO
taskHookLib (1), taskVarLib (1), semLib (1), kernelLib (1), "Architecture"
