.TH spyLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
spyLib.c - spy CPU activity library 
.SH SYNOPSIS
.nf
spyClkStart - start collecting task activity data
spyClkStop - stop collecting task activity data
spyReport - display task activity data
spyTask - run periodic task activity reports
spyStop - stop spying and reporting
spy - begin periodic task activity reports
spyHelp - print a helpful list of the task activity commands

STATUS spyClkStart (intsPerSec)
VOID spyClkStop ()
VOID spyReport ()
VOID spyTask (freq)
VOID spyStop ()
VOID spy (freq, ticksPerSec)
VOID spyHelp ()
.fi
.SH DESCRIPTION
This module provides a facility to monitor the CPU usage of all tasks.
The primary interface routine, spy (2), periodically prints a report
on CPU usage with spyReport (2).  The report shows CPU usage taken up by
interrupt level, idle state, and running tasks.
The total usage since the beginning of spy (or the most recent spyClkStart (2)),
and the change in usage (delta) since the last spyReport was displayed.

The facility can also be used "manually", instead of using spy.
In that case, spyClkStart is used to begin monitoring, and spyReport provides
a one-time report of the same information as provided by spy.

This data is gathered by an interrupt level routine that is connected by
spyClkStart to the auxiliary clock.  There is currently no way to use this
facility with CPU's that don't have an auxiliary clock.
Interrupts that are at a higher level than the auxiliary clock's
cannot be monitored.
