.TH semLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
semLib.c - VxWorks semaphore library 
.SH SYNOPSIS
.nf
semCreate - create and initialize a semaphore
semGive - give semaphore
semTake - take semaphore
semDelete - delete semaphore
semClear - take semaphore if semaphore is available
semInit - initialize a declared semaphore

SEM_ID semCreate ()
VOID semGive (semId)
VOID semTake (semId)
VOID semDelete (semId)
STATUS semClear (semId)
VOID semInit (semId)
.fi
.SH DESCRIPTION
This library provides a generic interface to the VxWorks kernel semaphores.
Semaphore management includes:

    - create/delete a semaphore,
    - initialize a semaphore,
    - take a semaphore,
    - take a semaphore if available,
    - give a semaphore.

.SH SEMAPHORES
This implementation provides a binary semaphore facility.  Semaphores can
be used to control access to shared devices or data structures, and
to synchronize multiple tasks, or task level and interrupt level processes.

A semaphore is just a cell in memory which contents is globally available.
The semaphore must be initialized (by semInit) before it
is ever used.  Thereafter, every time the semaphore is given (semGive) it
becomes full, and every time it is taken (semTake), it becomes empty.

.SH TASK STATE CHANGES
When a task takes a semaphore that is empty, that task will pend on the
filling of the semaphore.  Any number of tasks may be simultaneously pended on
the same semaphore.  If the semaphore is full when the semTake is done,
the semaphore is emptied and the calling task continues running.  At most,
a single task may have an instance of a semaphore at one time.

When a task gives a semaphore, that semaphore becomes full.  If any tasks are
pending on this semaphore the kernel unblocks the highest priority task waiting
on this semaphore, and the semaphore is emptied once again.  Otherwise, the
semaphore is simply filled and processing continues with the calling task.
Note that if a semaphore is given, and there is a task pending on this semaphore
of equal or higher priority than the task doing the semGive, that task will
unblock and execute, and the giving task will be preempted.  Unblocking a task
of lower priority, puts that task on the ready list but will not preempt the
calling task.

.SH INTERRUPT LEVEL USE
Semaphores may be given, but not taken, from interrupt level.  An interrupt
level process that gives a semaphore will not be preempted, no matter who
becomes ready, but the task that had been running when the interrupt
occurred may be preempted when an interrupt service routine completes.

.SH PROTOCOL HINTS
Although there is no restriction to many tasks giving, getting, and initializing
the same semaphore, one must be careful to ensure the proper functionality of
this construct.

There is no danger in any number of processes taking a semaphore as suited.
SemGives and semInits, however, should be more carefully controlled.  If
semGives are done only by one task, there is no problem.  If they are done by
multiple tasks, only a task that already has the semaphore should
give it.  Otherwise, multiple copies of the semaphore could be running
around, and mutual-exclusion will no longer be in effect.  SemInit's should
only be performed if some task (perhaps the same one that does the semInit)
is going to do a semGive without doing a semTake first.

.SH DEFICIENCIES
There is no mechanism to give back semaphores automatically
when tasks are suspended or deleted.  If a task ceases execution unexpectedly
(a bus error, deleted from the shell, etc.) any semaphores that it currently
has taken will never be given again, unless there is a watchdog or something
in operation that can do it.  Since the I/O system uses semaphores, this
can cause a device to get hung up if a task doing I/O to that device has
blown up.

.SH SEE ALSO
"Architecture", taskLib (1), kernelLib (1)
