.TH rt11Lib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
rt11Lib.c - RT-11 file I/O library 
.SH SYNOPSIS
.nf
rt11Close - close an RT-11 file
rt11Create - create an RT-11 file
rt11Delete - delete RT-11 file
rt11DevInit - initialize RT-11 device descriptor
rt11Init - prepare to use RT-11 library
rt11Ioctl - do device specific control function
rt11Open - open a file on an RT-11 volume
rt11Read - read from an RT-11 file
rt11DateSet - set current date
rt11Write - write to an RT-11 file
rt11ReadyChange - notify rt11Lib of a change in ready status
rt11ModeChange - modify mode of RT-11 volume

STATUS rt11Close (pfd)
RT_FILE_DESC *rt11Create (vdptr, name, mode)
STATUS rt11Delete (vdptr, name)
STATUS rt11DevInit (vdptr, bytesPerSec, secPerTrack, nSectors,  ...
STATUS rt11Init (maxFiles)
STATUS rt11Ioctl (pFd, function, arg)
RT_FILE_DESC *rt11Open (vdptr, name, mode)
int rt11Read (pfd, buffer, maxbytes)
VOID rt11DateSet (year, month, day)
int rt11Write (pfd, buffer, nbytes)
VOID rt11ReadyChange (vdptr)
VOID rt11ModeChange (vdptr, newMode)
.fi
.SH DESCRIPTION
This library provides services for file oriented device drivers which use
the RT-11 file standard.  This module takes care of all the buffering,
directory maintenance, and RT-11-specific details necessary.
The routines in this library are NOT to be called directly by users, but
rather by device drivers.

To use this library for a particular device, the device structure
must contain, as the very first item, an RT_VOL_DESC.  This is
initialized by calling rt11DevInit.  On that call, the driver gives the
addresses of three routines which it must supply, one that reads a sector,
one that writes a sector, and one that resets the device.
Those routines are described below. This call also specifies the maximum
number of files that can be contained in the device's directory, and
sets up the disk format (bytes/sector, sectors/track, etc.).

Thereafter, when the driver receives a request from the I/O system, it 
simply calls the corresponding routine in this module to fulfill that
request.  If the rt11Lib routine needs to actually access the device, it
does so via the rdSec and wrtSec routines which are in the RT_VOL_DESC.

When a file is opened with rt11Open or rt11Create, rt11Lib sets up an
RT_FILE_DESC that contains the information for that particular file on the disk.
This includes a pointer to the device's RT_VOL_DESC, the file pointers, 
starting block, extent, and block buffer.
A pointer to the file's RT_FILE_DESC is returned by rt11Open and rt11Close.
This pointer is then used to identify the file in subsequent calls to
the other file oriented functions, rt11Read, rt11Write, rt11Close, and several
control functions accessed through rt11Ioctl.

.SH RDSEC, WRTSEC, AND RESET
As noted above, the driver must supply routines to read and write single
sectors from the disk, and reset the device.  This is done in the call to
rt11DevInit.  For instance:

.CS
    rt11DevInit (vdptr,..., myRdSec, myWrtSec, myReset);
.CE

The read and write routines must be declared as follows:

.CS
    STATUS myWrtSec (devPtr, secNum, buffer)
        MY_DEVICE *devPtr;      /* pointer to device descriptor *
        int secNum;             /* number of sector to write    *
        char *buffer;           /* data to write to sector      *
.CE

The rdSec routine is identical, except the name must be different.
These routines must read (write) the specified sector from (to) disk, then
return a value of OK (if all went well) or ERROR (otherwise).

The reset routine should be declared as follows:

.CS
    STATUS myReset (devPtr)
        MY_DEVICE *devPtr;      /* pointer to device descriptor *
.CE

When called, the routine should reset the disk and controller.  This routine
is called each time a new volume is mounted, and during the error retry loop
for reading and writing blocks.  If the reset was successful, the routine should
return OK.  If not, it should return ERROR.  Volumes will be available only 
if the reset is successful.

The routine names may be anything desired; rt11Lib accesses these routines not
by name, but by the address passed in the rt11DevInit call.

.SH MULTIPLE LOGICAL DEVICES AND RT-11 COMPATIBILITY

The sector number passed to the sector read and write routines is an absolute
number, starting from sector 0 at the beginning of the device.  If desired,
the driver may add an offset from the beginning of the physical device
before the start of the logical device.  This would normally be done by
keeping a trackOffset parameter in the MY_DEVICE structure, and adding the
proper number of tracks to the sector passed to the read and write routines.

The RT-11 standard defines the disk to start on track 1.  Track 0 is set
aside for boot information, etc.  Therefore, in order to retain true
compatibility with RT-11 systems, a one track offset needs to be added
to the sector numbers passed to the sector read and write routines,
and the device size needs to be declared as one track smaller than it
actually is.  This must be done by the driver using this library.
rt11Lib does not add such an offset for you.

In the VxWorks implementation, the directory is a fixed size,
able to contain at least as many files as specified in the call to rt11DevInit.
If the maximum number of files is specified to be RT_FILES_FOR_2_BLOCK_SEG,
then strict RT-11 compatibility is maintained because this is the initial
allocation in the RT-11 standard.

.SH DIRECTORY ENTRIES
An ioctl call with function == FIODIRENTRY code returns information about a
particular directory entry.
A pointer to a REQ_DIR_ENTRY structure is passed as
the parameter.  The field "entryNum" in the REQ_DIR_ENTRY structure
must be set to the desired entry number.
The name of the file, its size (in bytes), and its creation date are
returned in the structure.
If the specified entry is empty, the name will
be an empty string, the size will be the space in this slot,
and the date will be meaningless.
Typically, the entries are accessed sequentially, starting
with entryNum = 0, until the terminating entry is reached,
indicated by a return code of ERROR.

.SH DIRECTORIES IN MEMORY
A copy of the directory for each volume is kept in memory (in the RT_VOL_DESC
structure).  This speeds up directory accesses, but requires that rt11Lib
be notified when disks are changed (i.e. floppies are swapped).
If the driver can find this out (by interrogating controller status or by
receiving an interrupt) the driver simply calls rt11ReadyChange when a disk
is inserted or removed.  rt11Lib will automatically try to mount the device 
next time it needs it.

If the driver does not have access to the information that disk volumes
have been changed, rt11ReadyChange must be called at somewhat arbitrary times.
It should probably be called before each open, create, delete,
and directory listing.

rt11ReadyChange can also be called by user tasks by issuing an ioctl call
with FIODISKCHANGE as the function code.  

.SH RTFMT
The RT-11 standard defines a peculiar software interleave and
track-to-track skew as part of the format.  The rtFmt parameter passed to
rt11DevInit should be TRUE if this formatting is desired.  This
should be the case if strict RT-11 compatibility is desired, or if files
must be transferred between the development and target machines using
the VxWorks-supplied RT-11 tools.
Software interleave and skew will automatically be dealt with by rt11Lib.

When rtFmt has been passed as TRUE and the maximum number of files is
specified RT_FILES_FOR_2_BLOCK_SEG, the driver does not need to do
anything else (except to add the track offset as described above) to
maintain RT-11 compatibility.

Note that if the number of files under either a VxWorks system,
or an RT-11 system, is specified other than RT_FILES_FOR_2_BLOCK_SEG
compatibility is lost because VxWorks allocates a contiguous directory,
whereas RT-11 systems create chained directories.

.SH ACCESSING THE RAW DISK
rt11Lib recognizes a null filename as a special case in the rt11Open and
rt11Create calls, indicating access to the entire "raw" disk is desired, as
opposed to a file on the disk.
This is how a stream is obtained to a disk that doesn't have a file system.
For example, when one wants to initialize a new file system on the disk
use an ioctl call with FIODISKINIT.
To read the directory of a disk on which no file names are known,
open the "raw" disk and use an ioctl call with FIODIRENTRY.

.SH INITIALIZING RTLIB
Before any other routines in rt11Lib can be used, the routine rt11Init must
be called to initialize this library.
In this call, one specifies the maximum number of RT-11 files
that can be open simultaneously.  rt11Init allocates memory for that many
RT_FILE_DESCs.  Attempts to open more RT-11 files than the specified maximum
will result in errors from rt11Open and rt11Create.

.SH RT-11 HINTS
The RT-11 file system is much simpler than the more common
UNIX or MS-DOS file systems.  The advantage of RT-11 is its
speed; file access is made in at most one seek because files
are contiguous.  Some of the most common errors
for users with a UNIX background are:

    + only one create at a time may be active per device.
    + file size is set by the first create and close sequence;
        to ensure a specific file size use lseek;
        there is no append function to expand a file.
    + files are strictly block oriented, unused portions
        of a block are filled with NULL's -- there is no
        end-of-file marker other than the last block.

.SH INCLUDE FILE
rt11Lib.h

.SH SEE ALSO
"I/O System", ioLib (1), iosLib (1), ramDrv (3)
