.TH pathLib 1 "" "VxWorks Reference Manual"
.ad b
.SH NAME
pathLib.c - file/directory path library 
.SH SYNOPSIS
.nf
pathCondense - condense a file or directory path
pathAppend - generate path name by concatenating an array of directory names
pathBuild - generate path name by concatenating a list of directory names
pathCat - concatenate directory path to file name
pathLastName - point to the last name in a path name
pathRemoveTail - remove the last directory name from a path name
pathSplit - split a path name into its directory and file parts

VOID pathCondense (pathName)
VOID pathAppend (destString, nameArray, stringIndex)
VOID pathBuild (nameArray, stringIndex, destString)
VOID pathCat (dirName, fileName, result)
VOID pathLastName (pathName, pLastName)
VOID pathRemoveTail (pathName)
VOID pathSplit (fullFileName, dirName, fileName)
.fi
.SH DESCRIPTION
This library provides functions for manipulating and parsing directory
and file path names for heirarchical file systems.
The path names are UNIX style with directory names separated by '/'s.
The directory '.' refers to the current directory.
The directory '..' refers to the parent directory.
Path names are handled in two forms:
as a null terminated string (such as "/abc/dir/file"), or
as an array of directory names
(such as a char** array with the entries "abc", "dir", "file", and NULL).

.SH SEE ALSO
ioLib (1), iosDevFind (2)
